PL_5EII_AA = {
	category		= CAT_AIR_TO_AIR,
	name			= "AIM_9X3", 
	user_name		= _("AIM-9X-3"),
	display_name_short = "AIM-9X3",
	wsTypeOfWeapon 	= {wsType_Weapon,wsType_Missile,wsType_AA_Missile,WSTYPE_PLACEHOLDER},
    Escort = 0,
    Head_Type = 1,   
	sigma = {1, 1, 1},
    M = 84.46,
    H_max = 18000.0,
    H_min = -1,
    Diam = 127.0,
    Cx_pil = AIM_9_CX_PIL,
    D_max = 20000.0,
    D_min = 50.0,
    Head_Form = 0,
    Life_Time = 120.0,
    Nr_max = 70,
    v_min = 100.0,
    v_mid = 750.0,
    Mach_max = 3.1,
    t_b = 0.0,
    t_acc = 6.0,
    t_marsh = 0.0,
    Range_max = 46400.0,
    H_min_t = 1.0,
    Fi_start = 3.14152,
    Fi_rak = 3.14152,
    Fi_excort = 2.50,
    Fi_search = 2.0,
    OmViz_max = 1.10,
    warhead = predefined_warhead("AIM_9"),
    exhaust = { 0.7, 0.7, 0.7, 0.08 },
	smoke_opacity_type = 1,
    X_back = -1.6,
    Y_back = 0.0,
    Z_back = 0.0,
    Reflection = 0.03,
    KillDistance = 9.0,

	SeekerGen = 4,  
	SeekerSensivityDistance = 46400, 
	ccm_k0 = 0.001,  
	SeekerCooled = true,
	x_wing_anim = -1,
	PN_gain = 6,
	SeekerGen = 4,

	shape_table_data =
	{
		{
			name	 = "AIM_9X3",
			file	 = "AIM-9X3",
			life	 = 1,
			fire	 = { 0, 1},
			username = "AIM-9X3",
			index 	 = WSTYPE_PLACEHOLDER,
		},
	},
	
	supersonic_A_coef_skew = 0.3, 
	nozzle_exit_area =	0.0068, 

	ModelData = {58,  --MODEL PARAMETERS
		0.35,   
		
		-- Drag (Сx) 
		0.04, 
		0.08, 
		0.02,
		0.05, 
		1.2,  
--		1.0, --Additional g’s due to thrust vectoring/rocket motors 
		5.0, --Additional g’s due to thrust vectoring/rocket motors 		
		
		-- Lift (Cy) 
		1.2, 
		0.8, 
		1.0,  
		
		0.5, 
		2.0, 
		
		--ENGINE DATA, VALUES FOR TIME, FUEL FLOW AND THRUST
		--t_statr		t_b		t_accel		t_march		t_inertial		t_break		t_end	 -- Stage
--		-1.0,		   -1.0,	8.0,  		0.0,		0.0,			0.0,		1.0e9,   -- time of stage in sec
		-1.0,		   -1.0,	12.0,  		0.0,		0.0,			0.0,		1.0e9,   -- time of stage in sec
		0.0,		    0.0,	6.0,		0.0,		0.0,			0.0,		0.0,     -- fuel flow rate in second, kg/sec
		0.0,		    0.0,	26683.2,	0.0,	    0.0,			0.0,		0.0,     -- thrust in newtons
		
		1.0e9, 
		120.0, --LIFETIME (FM)
		0, 
		0.45, 
		1.0e9, 
		1.0e9, 
		0.0, 
		30.0, 
		0.0, 
		2.2, 
		1.0, 
		1.0, 
		--DLZ--LAUNCH PAARAMETER TABLE== IR MISSILES
		9.0,
		-13.0, 
		-2.1, 
		26401.6,  --HEAD ON,     5000  (M) ALTITUDE AT 900 (KPH)	MAX_RANGE * 0.569
		10393.6,  --TAIL CHASE,  5000  (M) ALTITUDE AT 900 (KPH)	MAX_RANGE * 0.224
		46400.0,  --HEAD ON,     10000 (M) ALTITUDE AT 900 (KPH) 	MAX_RANGE * 1.000
		19209.6,  --TAIL CHASE,  10000 (M) ALTITUDE AT 900 (KPH)	MAX_RANGE * 0.414
		18420.8,  --HEAD ON,     1000  (M) ALTITUDE AT 900 (KPH)	MAX_RANGE * 0.397
		5614.4,   --TAIL CHASE,  1000  (M) ALTITUDE AT 900 (KPH)	MAX_RANGE * 0.121
		2500.0, 
		0.55, 
		-0.01, 
		0.5, 
	},	
}

declare_weapon(PL_5EII_AA)

declare_loadout({
    category     = CAT_AIR_TO_AIR,
    CLSID        = 'DIS_PL-5EII',
    Picture      = 'us_AIM-9X3.png',
    attribute    = PL_5EII_AA.wsTypeOfWeapon,
    displayName  = _("AIM-9X-3 Sidewinder IR AAM"),
    Count        = 1,
    Weight       = 84.46,
    Elements     = {
        [1] =
        {
            DrawArgs =
            {
                [1] = {1, 1},
                [2] = {2, 1},
            }, -- end of DrawArgs
            Position  = {0, 0, 0},
            ShapeName = 'AIM-9X3',
        },
    }, -- end of Elements
})


---------------------------
----- smoke generators PL5
local smokes =
{
    ['RED']     = {r = 245  , g = 40 ,  b = 40  , a = 180 , disp = _('red_smk')},
    ['GREEN']   = {r = 50   , g = 160,  b = 100 , a = 180 , disp = _('green')},
    ['BLUE']    = {r = 50   , g = 100,  b = 210 , a = 180 , disp = _('blue_smk')},
    ['YELLOW']  = {r = 255  , g = 230,  b = 50  , a = 180 , disp = _('yellow')},
    ['ORANGE']  = {r = 255  , g = 150,  b = 35  , a = 180 , disp = _('orange')},
    ['WHITE']   = {r = 255  , g = 255,  b = 255 , a = 180 , disp = _('white')},
}

local function smoke_generator_PL5(clsid, att, smoke, BlendColor, have_mass)
    local mass_ = 0
    local cx_ = 0
    if have_mass then
        mass_ = pl5eii_mass + pylon_mass
        cx_   = 0.00058828125
    end

    return {
        category          = CAT_PODS,
        CLSID             = clsid,
        attribute         = att,
        Picture           ='smoke.png',
        PictureBlendColor = BlendColor,
        displayName       = _('Smoke Generator') .. ' - ' .. smoke.disp,
        Weight            = mass_,
        Cx_pil            = cx_,
        Smoke  = {
            alpha = smoke.a,
            r     = smoke.r,
            g     = smoke.g,
            b     = smoke.b,
            dx    = -2.0,
            dy    = -0.09,
        },
        Elements = {{ShapeName = 'pl5eii'}},
    }
end

declare_loadout(smoke_generator_PL5('DIS_SMOKE_GENERATOR_R', {4, 15, 50, 67}, smokes['RED'],    '0xf52828b4', false))
declare_loadout(smoke_generator_PL5('DIS_SMOKE_GENERATOR_G', {4, 15, 50, 87}, smokes['GREEN'],  '0x32a064b4', false))
declare_loadout(smoke_generator_PL5('DIS_SMOKE_GENERATOR_B', {4, 15, 50, 88}, smokes['BLUE'],   '0x3264d2b4', false))
declare_loadout(smoke_generator_PL5('DIS_SMOKE_GENERATOR_W', {4, 15, 50, 89}, smokes['WHITE'],  '0xffffffb4', false))
declare_loadout(smoke_generator_PL5('DIS_SMOKE_GENERATOR_Y', {4, 15, 50, 90}, smokes['YELLOW'], '0xffe632b4', false))
declare_loadout(smoke_generator_PL5('DIS_SMOKE_GENERATOR_O', {4, 15, 50, 91}, smokes['ORANGE'], '0xff9623b4', false))
